/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.DbAttribute;
import ibm.nways.jdm.database.DbInvalidValueTypeException;
import ibm.nways.jdm.database.jdbc.DbJdbcColumnType;
import ibm.nways.jdm.database.jdbc.DbJdbcOperatorValueMismatchException;
import ibm.nways.jdm.database.jdbc.DbJdbcValue;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public class DbJdbcColumn
extends DbAttribute
implements Serializable {
    private static ResourceBundle strings = ResourceBundle.getBundle("ibm.nways.jdm.database.jdbc.DbJdbcResources");
    public static final int NO_AGGREGATION = 0;
    public static final int SUM = 1;
    public static final int AVERAGE = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int COUNT = 5;
    private static final int FIRST_AGGREGATION = 0;
    private static final int LAST_AGGREGATION = 5;
    public static final int EQUALS = 0;
    public static final int LESS_THAN = 1;
    public static final int GREATER_THAN = 2;
    public static final int LESS_THAN_OR_EQUAL_TO = 3;
    public static final int GREATER_THAN_OR_EQUAL_TO = 4;
    public static final int NOT_EQUAL_TO = 5;
    public static final int LIKE = 6;
    public static final int IN = 7;
    public static final int BETWEEN = 8;
    private static final int FIRST_OPERATOR = 0;
    private static final int LAST_OPERATOR = 8;
    protected String alias;
    protected boolean required = false;
    protected int aggregate = 0;
    protected int operator = 0;

    public DbJdbcColumn() {
    }

    public DbJdbcColumn(String string, DbJdbcColumnType dbJdbcColumnType) {
        super((Object)string, dbJdbcColumnType);
    }

    public DbJdbcColumn(String string, DbJdbcValue dbJdbcValue) {
        super((Object)string, dbJdbcValue);
    }

    public DbJdbcColumn(String string, int n, DbJdbcValue dbJdbcValue) throws IllegalArgumentException, DbJdbcOperatorValueMismatchException, DbInvalidValueTypeException {
        super((Object)string, dbJdbcValue.getType());
        this.setColumnValue(dbJdbcValue, n);
    }

    public void setAggregate(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.aggregate = n;
    }

    public int getAggregate() {
        return this.aggregate;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getAlias() {
        return this.alias;
    }

    private void validateOperatorValue(DbJdbcValue dbJdbcValue, int n) throws DbJdbcOperatorValueMismatchException {
        boolean bl = true;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (dbJdbcValue.getConstruct() == 0 || dbJdbcValue.getConstruct() == 1) break;
                bl = false;
                break;
            }
            case 6: {
                DbJdbcColumnType dbJdbcColumnType = dbJdbcValue.getColumnType();
                if (dbJdbcColumnType.getType() == 1) break;
                bl = false;
                break;
            }
            case 7: {
                if (dbJdbcValue.getConstruct() == 2 || dbJdbcValue.getConstruct() == 1) break;
                bl = false;
                break;
            }
            case 8: {
                if (dbJdbcValue.getConstruct() == 3) break;
                bl = false;
                break;
            }
        }
        if (!bl) {
            throw new DbJdbcOperatorValueMismatchException(n, dbJdbcValue);
        }
    }

    public String getColumnName() {
        return (String)this.getName();
    }

    public void setColumnName(String string) {
        this.setName(string);
    }

    public DbJdbcColumnType getColumnType() {
        return (DbJdbcColumnType)this.type;
    }

    public void setColumnType(DbJdbcColumnType dbJdbcColumnType) {
        this.setType(dbJdbcColumnType);
        this.value = null;
    }

    public DbJdbcValue getColumnValue() {
        return (DbJdbcValue)this.getValue();
    }

    public void setColumnValue(DbJdbcValue dbJdbcValue) throws DbInvalidValueTypeException {
        this.setValue(dbJdbcValue);
    }

    public void setColumnValue(DbJdbcValue dbJdbcValue, int n) throws IllegalArgumentException, DbJdbcOperatorValueMismatchException, DbInvalidValueTypeException {
        this.setValue(dbJdbcValue);
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.validateOperatorValue(dbJdbcValue, n);
        this.operator = n;
    }

    String getFullName() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.aggregate) {
            case 0: {
                stringBuffer.append(this.getColumnName());
                break;
            }
            case 1: {
                stringBuffer.append("sum(").append(this.getColumnName()).append(")");
                break;
            }
            case 2: {
                stringBuffer.append("avg(").append(this.getColumnName()).append(")");
                break;
            }
            case 3: {
                stringBuffer.append("min(").append(this.getColumnName()).append(")");
                break;
            }
            case 4: {
                stringBuffer.append("max(").append(this.getColumnName()).append(")");
                break;
            }
            case 5: {
                stringBuffer.append("count(*)");
                break;
            }
        }
        if (this.alias != null) {
            stringBuffer.append(" AS ").append("\"").append(this.alias).append("\"");
        }
        return stringBuffer.toString();
    }

    String getNameValueString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getColumnName());
        if (this.value != null) {
            stringBuffer.append(" ").append(DbJdbcColumn.getOperatorString(this.operator)).append(" ").append(this.getValueString());
        }
        return stringBuffer.toString();
    }

    String getValueString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value == null) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(this.value.toString());
        }
        return stringBuffer.toString();
    }

    String getNameTypeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getColumnName()).append(" ").append(this.type.toString());
        if (this.required) {
            stringBuffer.append(" NOT NULL");
        }
        return stringBuffer.toString();
    }

    public static String getOperatorString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "=";
                break;
            }
            case 1: {
                string = "<";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 3: {
                string = "<=";
                break;
            }
            case 4: {
                string = ">=";
                break;
            }
            case 5: {
                string = "<>";
                break;
            }
            case 6: {
                string = "LIKE";
                break;
            }
            case 7: {
                string = "IN";
                break;
            }
            case 8: {
                string = "BETWEEN";
                break;
            }
        }
        return string;
    }

    public static String getAggregationString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = strings.getString("NO_AGGREGATION");
                break;
            }
            case 1: {
                string = strings.getString("SUM");
                break;
            }
            case 2: {
                string = strings.getString("AVERAGE");
                break;
            }
            case 3: {
                string = strings.getString("MIN");
                break;
            }
            case 4: {
                string = strings.getString("MAX");
                break;
            }
            case 5: {
                string = strings.getString("COUNT");
                break;
            }
        }
        return string;
    }

    public static Vector getAllOperators() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n <= 8) {
            vector.addElement(strings.getString(DbJdbcColumn.getOperatorString(n)));
            ++n;
        }
        return vector;
    }

    public static Vector getAllAggregations() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n <= 5) {
            vector.addElement(DbJdbcColumn.getAggregationString(n));
            ++n;
        }
        return vector;
    }

    public String toString() {
        return this.getNameValueString();
    }
}

